## 加法器

基本思路：考虑模拟竖式加法，用特殊符号标识已经计算的 

符号集：$0\ 1\ 2\ ,\ *\ \#$ 以及空格。 

状态集：

状态集由若干二元组 $(\texttt{key},\texttt{val})$ 构成，分别表示当前的任务和存储的值：

| Reset | Read | Trans | Inc  | Write | Halt |
| ----- | ---- | ----- | ---- | ----- | ---- |
| $0$   | $-1$ | $-1$  | $0$  |       |      |
| $1$   | $0$  | $0$   | $1$  |       |      |
|       | $1$  | $1$   |      |       |      |
|       |      | $2$   |      |       |      |

具体含义如下：

- $\texttt{Reset}$ 表示当前正在进行复位操作：
  - $0$ 表示现在处在加法阶段的左移。
  - $1$ 表示现在进行进位阶段的复位。
- $\texttt{Read}$ 表示当且正在读取 $x$ 或 $y$ 的数值，且已经读取的数值是：
  - $-1$ 表示读取了某个数的前导零。
  - $0,1$ 为具体数值。
- $\texttt{Trans}$ 表示正在运送刚才读入的数值（准备写入或还未开始读入下一位），$\texttt{val}$ 的含义同理。
- $\texttt{Inc}$ 为进位器，$\texttt{val}$ 的表示当前进位。
- $\texttt{Write}$ 的功能较为简单，表示已经写完的状态，向后补终止符。
- $\texttt{Halt}$ 表示停止。





|                       | $0$                                   | $1$                                   | $2$                                   | $\_$                                 | $*$                                    | $\#$                                   | $,$                                   | 空                                    |
| --------------------- | ------------------------------------- | ------------------------------------- | ------------------------------------- | ------------------------------------ | -------------------------------------- | -------------------------------------- | ------------------------------------- | ------------------------------------- |
| $(\texttt{Reset},0)$  | $((\texttt{Reset},0),\ ,\texttt{L})$  | $((\texttt{Reset},0),\ ,\texttt{L})$  | $((\texttt{Reset},0),\ ,\texttt{L})$  | $((\texttt{Read},0),\ ,\texttt{L})$  | $((\texttt{Reset},0),\ ,\texttt{L})$   | $((\texttt{Reset},0),\ ,\texttt{L})$   | $((\texttt{Read},-1),\ ,\texttt{R})$  |                                       |
| $(\texttt{Reset},1)$  | $((\texttt{Reset},1),\ ,\texttt{L})$  | $((\texttt{Reset},1),\ ,\texttt{L})$  | $((\texttt{Reset},1),\ ,\texttt{L})$  |                                      |                                        | $((\texttt{Inc},0),\ ,\texttt{R})$     |                                       |                                       |
| $(\texttt{Read},-1)$  | $((\texttt{Trans},0),\_ ,\texttt{R})$ | $((\texttt{Trans},1),\_ ,\texttt{R})$ |                                       | $((\texttt{Read},-1),\ ,\texttt{R})$ | $((\texttt{Trans},-1),\_ ,\texttt{R})$ | $((\texttt{Trans},-1),\_ ,\texttt{R})$ |                                       |                                       |
| $(\texttt{Read},0)$   | $((\texttt{Trans},0),\_ ,\texttt{R})$ | $((\texttt{Trans},1),\_ ,\texttt{R})$ |                                       | $((\texttt{Read},0),\ ,\texttt{R})$  | $((\texttt{Trans},0),\_ ,\texttt{R})$  | $((\texttt{Trans},0),\_ ,\texttt{R})$  |                                       |                                       |
| $(\texttt{Read},1)$   | $((\texttt{Trans},1),\_ ,\texttt{R})$ | $((\texttt{Trans},2),\_ ,\texttt{R})$ |                                       | $((\texttt{Read},1),\ ,\texttt{R})$  | $((\texttt{Trans},1),\_ ,\texttt{R})$  | $((\texttt{Trans},1),\_ ,\texttt{R})$  |                                       |                                       |
| $(\texttt{Trans},-1)$ | $((\texttt{Trans},-1),\ ,\texttt{R})$ | $((\texttt{Trans},-1),\ ,\texttt{R})$ | $((\texttt{Trans},-1),\ ,\texttt{R})$ |                                      | $((\texttt{Read},-1),\  ,\texttt{R})$  | $((\texttt{Trans},-1),\ ,\texttt{R})$  | $((\texttt{Reset},1),\  ,\texttt{L})$ |                                       |
| $(\texttt{Trans},0)$  | $((\texttt{Trans},0),\ ,\texttt{R})$  | $((\texttt{Trans},0),\ ,\texttt{R})$  | $((\texttt{Trans},0),\ ,\texttt{R})$  |                                      | $((\texttt{Read},0),\  ,\texttt{R})$   | $((\texttt{Trans},0),\ ,\texttt{R})$   | $(\texttt{Write},0 ,\texttt{R})$      |                                       |
| $(\texttt{Trans},1)$  | $((\texttt{Trans},1),\ ,\texttt{R})$  | $((\texttt{Trans},1),\ ,\texttt{R})$  | $((\texttt{Trans},1),\ ,\texttt{R})$  |                                      | $((\texttt{Read},1),\  ,\texttt{R})$   | $((\texttt{Trans},1),\ ,\texttt{R})$   | $(\texttt{Write},1 ,\texttt{R})$      |                                       |
| $(\texttt{Trans},2)$  | $((\texttt{Trans},2),\ ,\texttt{R})$  | $((\texttt{Trans},2),\ ,\texttt{R})$  | $((\texttt{Trans},2),\ ,\texttt{R})$  |                                      | $((\texttt{Read},2),\  ,\texttt{R})$   | $((\texttt{Trans},2),\ ,\texttt{R})$   | $(\texttt{Write},2 ,\texttt{R})$      |                                       |
| $(\texttt{Inc},0)$    | $((\texttt{Inc},0),0 ,\texttt{R})$    | $((\texttt{Inc},0),1 ,\texttt{R})$    | $((\texttt{Inc},1),0 ,\texttt{R})$    |                                      |                                        |                                        | $\texttt{Halt}$                       |                                       |
| $(\texttt{Inc},1)$    | $((\texttt{Inc},0),1 ,\texttt{R})$    | $((\texttt{Inc},1), 0,\texttt{R})$    | $((\texttt{Inc},1),1 ,\texttt{R})$    |                                      |                                        |                                        | $(\texttt{Halt},1 ,\texttt{R})$       |                                       |
| $\texttt{Write}$      |                                       |                                       |                                       |                                      |                                        |                                        |                                       | $$((\texttt{Reset},0),,,\texttt{L})$$ |

上述空格表示不会遇到这种情况。

起始位置：$(\texttt{Reset},0)$，任意非空位置和非最右位置。
